/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentLinkedBlockingQueue<T>
extends ConcurrentLinkedQueue<T>
implements BlockingQueue<T> {
    private static final long serialVersionUID = -8884995454506956809L;
    private final int capacity;
    private final Lock lock = new ReentrantLock();
    private final Condition not_empty = this.lock.newCondition();
    private final AtomicInteger waiting_takers = new AtomicInteger(0);

    public ConcurrentLinkedBlockingQueue(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public boolean offer(T t2) {
        boolean retval;
        boolean bl = retval = this.size() < this.capacity && super.offer(t2);
        if (this.waiting_takers.get() > 0) {
            this.lock.lock();
            try {
                this.not_empty.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
        return retval;
    }

    @Override
    public T take() throws InterruptedException {
        T retval = null;
        block3: while ((retval = (T)this.poll()) == null) {
            while (true) {
                if (this.size() != 0) continue block3;
                this.waiting_takers.incrementAndGet();
                this.lock.lockInterruptibly();
                try {
                    this.not_empty.await();
                    continue;
                }
                finally {
                    this.lock.unlock();
                    this.waiting_takers.decrementAndGet();
                    continue;
                }
                break;
            }
            break;
        }
        return retval;
    }

    @Override
    public T poll() {
        return (T)super.poll();
    }

    @Override
    public T poll(long timeout2, TimeUnit unit) throws InterruptedException {
        long sleep_time_nanos = TimeUnit.NANOSECONDS.convert(timeout2, unit);
        long target_time_nanos = System.nanoTime() + sleep_time_nanos;
        sleep_time_nanos /= 5L;
        T el = null;
        while (System.nanoTime() < target_time_nanos) {
            T t2 = this.poll();
            el = t2;
            if (t2 != null) {
                return el;
            }
            LockSupport.parkNanos(sleep_time_nanos);
        }
        return el;
    }

    @Override
    public boolean remove(Object o) {
        return super.remove(o);
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.size();
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        T el;
        int count = 0;
        if (c == null) {
            return count;
        }
        while ((el = this.poll()) != null) {
            c.add(el);
            ++count;
        }
        return count;
    }

    @Override
    public void put(T t2) throws InterruptedException {
        super.offer(t2);
    }

    @Override
    public boolean offer(T t2, long timeout2, TimeUnit unit) throws InterruptedException {
        return this.offer(t2);
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        return this.drainTo(c);
    }
}

