/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jgroups.util.AsciiString;
import org.jgroups.util.FlagsUUID;
import org.jgroups.util.NameCache;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class ExtendedUUID
extends FlagsUUID {
    protected byte[][] keys;
    protected byte[][] values;
    protected static Function<ExtendedUUID, String> print_function = ExtendedUUID::print;

    public ExtendedUUID() {
    }

    protected ExtendedUUID(byte[] data2) {
        super(data2);
    }

    public ExtendedUUID(long mostSigBits, long leastSigBits) {
        super(mostSigBits, leastSigBits);
    }

    public <T extends FlagsUUID> ExtendedUUID(T o) {
        super(o);
        if (o instanceof ExtendedUUID) {
            ExtendedUUID other = (ExtendedUUID)o;
            if (other.keys != null) {
                this.keys = (byte[][])Arrays.copyOf(other.keys, other.keys.length);
                this.values = (byte[][])Arrays.copyOf(other.values, other.values.length);
            }
        }
    }

    @Override
    public Supplier<? extends UUID> create() {
        return ExtendedUUID::new;
    }

    public static void setPrintFunction(Function<ExtendedUUID, String> f) {
        print_function = f;
    }

    public static ExtendedUUID randomUUID() {
        return new ExtendedUUID(ExtendedUUID.generateRandomBytes());
    }

    public static ExtendedUUID randomUUID(String name) {
        ExtendedUUID retval = new ExtendedUUID(ExtendedUUID.generateRandomBytes());
        if (name != null) {
            NameCache.add(retval, name);
        }
        return retval;
    }

    public byte[] get(byte[] key) {
        if (this.keys == null || key == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte[] k = this.keys[i];
            if (k == null || !Arrays.equals(k, key)) continue;
            return this.values[i];
        }
        return null;
    }

    public byte[] get(String key) {
        return this.get(Util.stringToBytes(key));
    }

    public ExtendedUUID put(byte[] key, byte[] val) {
        return this.put(0, key, val);
    }

    protected ExtendedUUID put(int start_index, byte[] key, byte[] val) {
        if (val != null && val.length > 255) {
            throw new IllegalArgumentException("value has to be <= 255 bytes");
        }
        if (this.keys == null) {
            this.resize(3);
        }
        for (int i = start_index; i < this.keys.length; ++i) {
            byte[] k = this.keys[i];
            if (k != null && !Arrays.equals(key, k)) continue;
            this.keys[i] = key;
            this.values[i] = val;
            return this;
        }
        int index = this.keys.length;
        this.resize(this.keys.length + 3);
        return this.put(index, key, val);
    }

    public ExtendedUUID put(String key, byte[] val) {
        return this.put(Util.stringToBytes(key), val);
    }

    public byte[] remove(byte[] key) {
        if (this.keys == null || key == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte[] k = this.keys[i];
            if (k == null || !Arrays.equals(k, key)) continue;
            byte[] old_val = this.values[i];
            this.values[i] = null;
            this.keys[i] = null;
            return old_val;
        }
        return null;
    }

    public byte[] remove(String key) {
        return this.remove(Util.stringToBytes(key));
    }

    public boolean keyExists(byte[] key) {
        if (this.keys == null || key == null) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte[] k = this.keys[i];
            if (k == null || !Arrays.equals(k, key)) continue;
            return true;
        }
        return false;
    }

    public boolean keyExists(String key) {
        return this.keyExists(Util.stringToBytes(key));
    }

    @Override
    public <T extends FlagsUUID> T addContents(T o) {
        super.addContents(o);
        if (o instanceof ExtendedUUID) {
            ExtendedUUID other = (ExtendedUUID)o;
            if (other.keys != null) {
                for (int i = 0; i < other.keys.length; ++i) {
                    byte[] key = other.keys[i];
                    byte[] val = other.values[i];
                    if (this.keyExists(key)) continue;
                    this.put(key, val);
                }
            }
        }
        return (T)this;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        this.write(out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.read(in);
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 1 + this.sizeofHashMap();
    }

    public int length() {
        if (this.keys == null) {
            return 0;
        }
        int retval = 0;
        for (byte[] key : this.keys) {
            if (key == null) continue;
            ++retval;
        }
        return retval;
    }

    @Override
    public String toString() {
        if (print_function != null) {
            return print_function.apply(this);
        }
        return this.print();
    }

    public String print() {
        if (this.keys == null) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder(super.toString());
        boolean first = true;
        if (this.keys != null) {
            sb.append("(");
        }
        for (int i = 0; i < this.keys.length; ++i) {
            Object obj2;
            byte[] key = this.keys[i];
            if (key == null) continue;
            byte[] val = this.values[i];
            Object object = obj2 = val != null && val.length >= Util.MAX_LIST_PRINT_SIZE ? val.length + " bytes" : null;
            if (val != null && val.length <= Util.MAX_LIST_PRINT_SIZE && obj2 == null) {
                try {
                    obj2 = Util.bytesToString(val);
                }
                catch (Throwable t2) {
                    Object object2 = obj2 = val != null ? val.length + " bytes" : null;
                }
            }
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(new AsciiString(key)).append("=").append(obj2);
        }
        if (this.keys != null) {
            sb.append(")");
        }
        return sb.toString();
    }

    protected void write(DataOutput out) throws IOException {
        int length = this.length();
        out.writeByte(length);
        if (this.keys == null) {
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte[] k = this.keys[i];
            if (k == null) continue;
            out.writeByte(k.length);
            out.write(k);
            byte[] v = this.values[i];
            out.writeByte(v != null ? v.length : 0);
            if (v == null) continue;
            out.write(v);
        }
    }

    protected void read(DataInput in) throws IOException {
        int length = in.readUnsignedByte();
        if (length == 0) {
            return;
        }
        this.resize(length);
        for (int i = 0; i < length; ++i) {
            int len = in.readUnsignedByte();
            this.keys[i] = new byte[len];
            in.readFully(this.keys[i]);
            len = in.readUnsignedByte();
            if (len <= 0) continue;
            this.values[i] = new byte[len];
            in.readFully(this.values[i]);
        }
    }

    protected int sizeofHashMap() {
        if (this.keys == null) {
            return 0;
        }
        int retval = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            byte[] key = this.keys[i];
            if (key == null) continue;
            retval += key.length + 1;
            byte[] val = this.values[i];
            retval += 1 + (val != null ? val.length : 0);
        }
        return retval;
    }

    protected void resize(int new_length) {
        if (this.keys == null) {
            this.keys = new byte[Math.min(new_length, 255)][];
            this.values = new byte[Math.min(new_length, 255)][];
            return;
        }
        if (new_length > 255) {
            if (this.keys.length < 255) {
                new_length = 255;
            } else {
                throw new ArrayIndexOutOfBoundsException("the hashmap cannot exceed 255 entries");
            }
        }
        this.keys = (byte[][])Arrays.copyOf(this.keys, new_length);
        this.values = (byte[][])Arrays.copyOf(this.values, new_length);
    }
}

