/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jgroups.util.ByteArray;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class ObjectWrapper
implements SizeStreamable {
    protected Object obj;
    protected ByteArray serialized;

    public ObjectWrapper() {
    }

    public ObjectWrapper(Object obj2) {
        this.obj = Objects.requireNonNull(obj2);
    }

    public <T> T getObject() {
        return (T)this.obj;
    }

    public synchronized ObjectWrapper setObject(Object obj2) {
        this.obj = obj2;
        this.serialized = null;
        return this;
    }

    public synchronized ByteArray getSerialized() {
        if (this.serialized != null) {
            return this.serialized;
        }
        try {
            this.serialized = Util.objectToBuffer(this.obj);
            return this.serialized;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getLength() {
        return this.getSerialized().getLength();
    }

    public String toString() {
        return String.format("obj: %s %s", this.obj, this.serialized != null ? "(" + this.serialized.getLength() + " bytes)" : "");
    }

    @Override
    public int serializedSize() {
        int retval = 4;
        if (this.obj == null) {
            return retval;
        }
        return retval + this.getLength();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.obj != null) {
            ByteArray arr = this.getSerialized();
            out.writeInt(arr.getLength());
            out.write(arr.getArray(), 0, arr.getLength());
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        if (len == -1) {
            return;
        }
        byte[] tmp = new byte[len];
        in.readFully(tmp, 0, len);
        this.serialized = new ByteArray(tmp);
        this.obj = Util.objectFromBuffer(this.serialized, null);
    }
}

