/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.util.SeqnoList;

public class RingBufferSeqno<T>
implements Iterable<T> {
    protected final T[] buf;
    protected long low;
    protected long hd;
    protected long hr;
    protected final long offset;
    protected final Lock lock = new ReentrantLock();
    protected final Condition buffer_full = this.lock.newCondition();
    protected boolean running = true;
    protected final AtomicBoolean processing = new AtomicBoolean(false);

    public RingBufferSeqno(int capacity, long offset) {
        int cap;
        if (capacity < 1) {
            throw new IllegalArgumentException("incorrect capacity of " + capacity);
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("invalid offset of " + offset);
        }
        for (cap = 1; capacity > cap; cap <<= 1) {
        }
        this.buf = new Object[cap];
        this.hr = this.offset = offset;
        this.hd = this.offset;
        this.low = this.offset;
    }

    public long getLow() {
        return this.low;
    }

    public long getHighestDelivered() {
        return this.hd;
    }

    public void setHighestDelivered(long hd) {
        this.hd = hd;
    }

    public long getHighestReceived() {
        return this.hr;
    }

    public long[] getDigest() {
        return new long[]{this.hd, this.hr};
    }

    public AtomicBoolean getProcessing() {
        return this.processing;
    }

    public boolean add(long seqno, T element) {
        return this.add(seqno, element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(long seqno, T element, boolean block) {
        this.lock.lock();
        try {
            if (seqno <= this.hd) {
                boolean bl = false;
                return bl;
            }
            if (!(seqno - this.low <= (long)this.capacity() || block && this.block(seqno))) {
                boolean bl = false;
                return bl;
            }
            int index = this.index(seqno);
            if (this.buf[index] != null) {
                boolean bl = false;
                return bl;
            }
            this.buf[index] = element;
            if (seqno > this.hr) {
                this.hr = seqno;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(boolean nullify) {
        this.lock.lock();
        try {
            long tmp = this.hd + 1L;
            if (tmp > this.hr) {
                T t2 = null;
                return t2;
            }
            int index = this.index(tmp);
            T element = this.buf[index];
            if (element == null) {
                T t3 = null;
                return t3;
            }
            this.hd = tmp;
            if (nullify) {
                if (tmp == this.low + 1L) {
                    this.buf[index] = null;
                } else {
                    int from = this.index(this.low + 1L);
                    int length = (int)(tmp - this.low);
                    int capacity = this.capacity();
                    for (int i = from; i < from + length; ++i) {
                        index = i & capacity - 1;
                        this.buf[index] = null;
                    }
                }
                this.low = tmp;
                this.buffer_full.signalAll();
            }
            T t4 = element;
            return t4;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T remove() {
        return this.remove(false);
    }

    public List<T> removeMany(boolean nullify, int max_results) {
        return this.removeMany(null, nullify, max_results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> removeMany(AtomicBoolean processing, boolean nullify, int max_results) {
        ArrayList<T> list = null;
        int num_results = 0;
        this.lock.lock();
        try {
            T element;
            long start = this.hd;
            long end = this.hr;
            while (start + 1L <= end && (element = this.buf[this.index(start + 1L)]) != null) {
                if (list == null) {
                    list = new ArrayList<T>(max_results > 0 ? max_results : 20);
                }
                list.add(element);
                ++start;
                if (max_results <= 0 || ++num_results < max_results) continue;
            }
            if (start > this.hd) {
                this.hd = start;
                if (nullify) {
                    int from = this.index(this.low + 1L);
                    int length = (int)(start - this.low);
                    int capacity = this.capacity();
                    for (int i = from; i < from + length; ++i) {
                        int index = i & capacity - 1;
                        this.buf[index] = null;
                    }
                    if (start > this.low) {
                        this.low = start;
                        this.buffer_full.signalAll();
                    }
                }
            }
            if ((list == null || list.isEmpty()) && processing != null) {
                processing.set(false);
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long seqno) {
        this.lock.lock();
        try {
            if (seqno <= this.low || seqno > this.hr) {
                T t2 = null;
                return t2;
            }
            int index = this.index(seqno);
            T t3 = this.buf[index];
            return t3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T _get(long seqno) {
        int index = this.index(seqno);
        this.lock.lock();
        try {
            T t2 = index < 0 ? null : (T)this.buf[index];
            return t2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<T> get(long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException("from (" + from + ") has to be <= to (" + to + ")");
        }
        ArrayList<T> retval = null;
        for (long i = from; i <= to; ++i) {
            T element = this.get(i);
            if (element == null) continue;
            if (retval == null) {
                retval = new ArrayList<T>();
            }
            retval.add(element);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stable(long seqno) {
        this.lock.lock();
        try {
            if (seqno <= this.low) {
                return;
            }
            if (seqno > this.hd) {
                throw new IllegalArgumentException("seqno " + seqno + " cannot be bigger than hd (" + this.hd + ")");
            }
            int from = this.index(this.low + 1L);
            int length = (int)(seqno - this.low);
            int capacity = this.capacity();
            for (int i = from; i < from + length; ++i) {
                int index = i & capacity - 1;
                this.buf[index] = null;
            }
            if (seqno > this.low) {
                this.low = seqno;
                this.buffer_full.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroy() {
        this.lock.lock();
        try {
            this.running = false;
            this.buffer_full.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public final int capacity() {
        return this.buf.length;
    }

    public int size() {
        return this.count(false);
    }

    public int missing() {
        return this.count(true);
    }

    public int spaceUsed() {
        return (int)(this.hr - this.low);
    }

    public double saturation() {
        int space = this.spaceUsed();
        return space == 0 ? 0.0 : (double)space / (double)this.capacity();
    }

    public SeqnoList getMissing() {
        SeqnoList missing = null;
        long tmp_hd = this.hd;
        long tmp_hr = this.hr;
        for (long i = tmp_hd + 1L; i <= tmp_hr; ++i) {
            long end;
            if (this.buf[this.index(i)] != null) continue;
            if (missing == null) {
                missing = new SeqnoList((int)(this.hr - this.hd), this.hd);
            }
            for (end = i; this.buf[this.index(end + 1L)] == null && end <= tmp_hr; ++end) {
            }
            if (end == i) {
                missing.add(i);
                continue;
            }
            missing.add(i, end);
            i = end;
        }
        return missing;
    }

    @Override
    public Iterator<T> iterator() {
        return new RingBufferIterator(this.buf);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + this.low + " | " + this.hd + " | " + this.hr + "] (" + this.size() + " elements, " + this.missing() + " missing)");
        return sb.toString();
    }

    protected int index(long seqno) {
        return (int)(seqno - this.offset - 1L & (long)(this.capacity() - 1));
    }

    protected boolean block(long seqno) {
        while (this.running && seqno - this.low > (long)this.capacity()) {
            try {
                this.buffer_full.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.running;
    }

    protected int count(boolean missing) {
        int retval = 0;
        long tmp_hd = this.hd;
        long tmp_hr = this.hr;
        for (long i = tmp_hd + 1L; i <= tmp_hr; ++i) {
            int index = this.index(i);
            T element = this.buf[index];
            if (missing && element == null) {
                ++retval;
            }
            if (missing || element == null) continue;
            ++retval;
        }
        return retval;
    }

    protected class RingBufferIterator
    implements Iterator<T> {
        protected final T[] buffer;
        protected long current;

        public RingBufferIterator(T[] buffer) {
            this.current = RingBufferSeqno.this.hd + 1L;
            this.buffer = buffer;
        }

        @Override
        public boolean hasNext() {
            return this.current <= RingBufferSeqno.this.hr;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.current <= RingBufferSeqno.this.hd) {
                this.current = RingBufferSeqno.this.hd + 1L;
            }
            return this.buffer[RingBufferSeqno.this.index(this.current++)];
        }

        @Override
        public void remove() {
        }
    }
}

