/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.Closeable;
import java.io.IOException;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.ThreadFactory;

public class Runner
implements Runnable,
Closeable {
    protected final ThreadFactory factory;
    protected String thread_name;
    protected final Runnable function;
    protected final Runnable stop_function;
    protected volatile boolean running;
    protected Thread thread;
    protected boolean daemon;
    protected long join_timeout = 100L;

    public Runner(String name, Runnable function, Runnable stop_function) {
        this(new DefaultThreadFactory(name, true, true), name, function, stop_function);
    }

    public Runner(ThreadFactory factory2, String thread_name, Runnable function, Runnable stop_function) {
        this.factory = factory2;
        this.thread_name = thread_name;
        this.function = function;
        this.stop_function = stop_function;
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean daemon() {
        return this.daemon;
    }

    public Runner daemon(boolean d) {
        this.daemon = d;
        return this;
    }

    public String threadName() {
        return this.thread_name;
    }

    public Runner threadName(String n) {
        this.thread_name = n;
        if (this.thread != null) {
            this.thread.setName(n);
        }
        return this;
    }

    public long getJoinTimeout() {
        return this.join_timeout;
    }

    public Runner setJoinTimeout(long t2) {
        this.join_timeout = t2;
        return this;
    }

    public synchronized Runner start() {
        if (this.running) {
            return this;
        }
        if (this.thread == null || !this.thread.isAlive()) {
            String name = this.thread_name != null ? this.thread_name : "runner";
            Thread thread2 = this.thread = this.factory != null ? this.factory.newThread(this, name) : new Thread((Runnable)this, name);
            if (this.thread.getClass() == Thread.class) {
                this.thread.setDaemon(this.daemon);
            }
            this.running = true;
            this.thread.start();
        }
        return this;
    }

    public synchronized Runner stop() {
        this.running = false;
        Thread tmp = this.thread;
        this.thread = null;
        if (tmp != null) {
            tmp.interrupt();
            if (tmp.isAlive()) {
                try {
                    tmp.join(this.join_timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.stop_function != null) {
            this.stop_function.run();
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.function.run();
            }
            catch (Throwable throwable) {}
        }
    }
}

