/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import java.util.concurrent.TimeUnit;
import org.jire.swiftfup.client.AutoProcessor;
import org.jire.swiftfup.client.FileClient;
import org.jire.swiftfup.client.FileRequests;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AutoProcessors implements AutoProcessor
{
    SLOW(TimeUnit.MILLISECONDS.toNanos(100L)),
    FAST(TimeUnit.MILLISECONDS.toNanos(20L));

    private static final Logger logger;
    private final long sleepTimeTargetNanos;

    private AutoProcessors(long sleepTimeTargetNanos) {
        this.sleepTimeTargetNanos = sleepTimeTargetNanos;
    }

    @Override
    public void autoProcess(FileClient fileClient, FileRequests fileRequests) {
        long start = System.nanoTime();
        try {
            fileRequests.process(fileClient);
        }
        catch (Exception e) {
            logger.error("Failed to process file requests", e);
        }
        long end = System.nanoTime();
        long elapsed = end - start;
        long sleepTimeNanos = this.sleepTimeTargetNanos - elapsed;
        long sleepTimeMillis = TimeUnit.NANOSECONDS.toMillis(sleepTimeNanos);
        if (sleepTimeMillis > 0L) {
            try {
                Thread.sleep(sleepTimeMillis);
            }
            catch (InterruptedException ie) {
                logger.error("Auto process was interrupted during sleep of " + sleepTimeMillis + "ms (target was " + this.sleepTimeTargetNanos + "ns)", ie);
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(AutoProcessors.class);
    }
}

