/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import java.net.SocketAddress;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.jire.swiftfup.client.FileClientChannelInitializer;
import org.jire.swiftfup.client.FileClientConnectInterruptedException;
import org.jire.swiftfup.client.FileRequests;
import org.jire.swiftfup.client.HandshakeResponse;
import org.jire.swiftfup.client.codec.HandshakeResponseHandler;

public final class FileClient {
    public static final long DEFAULT_TIMEOUT_NANOS = 5000000000L;
    public static final long MAX_TIMEOUT_NANOS = 30000000000L;
    private final FileRequests fileRequests;
    private final Bootstrap bootstrap;
    private final Consumer<Channel> whenReconnected;
    private final SocketAddress[] remoteAddresses;
    private volatile Channel channel;

    public FileClient(FileRequests fileRequests, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass, @Nullable Consumer<Channel> whenReconnected, SocketAddress ... remoteAddresses) {
        if (remoteAddresses == null || remoteAddresses.length == 0) {
            throw new IllegalArgumentException("Need to pass at least one address");
        }
        this.fileRequests = fileRequests;
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(channelClass)).group(eventLoopGroup)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 120000)).option(ChannelOption.SO_SNDBUF, 65536)).option(ChannelOption.SO_RCVBUF, 65536);
        this.whenReconnected = whenReconnected;
        this.remoteAddresses = remoteAddresses;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Channel createChannelFuture(boolean reconnect, @Nullable Runnable whileWaiting, Consumer<Channel> whenReconnected, long timeoutNanos) {
        Bootstrap bootstrap = (Bootstrap)this.bootstrap.handler(new FileClientChannelInitializer(this.fileRequests));
        ChannelFuture[] futures = new ChannelFuture[this.remoteAddresses.length];
        for (int i = 0; i < futures.length; ++i) {
            futures[i] = bootstrap.connect(this.remoteAddresses[i]);
        }
        long start = System.nanoTime();
        while (!Thread.interrupted() && System.nanoTime() - start < timeoutNanos) {
            for (ChannelFuture future : futures) {
                HandshakeResponse handshakeResponse;
                Channel channel;
                if (!future.isSuccess() || !(channel = future.channel()).isActive() || (handshakeResponse = channel.attr(HandshakeResponseHandler.HANDSHAKE_RESPONSE_ATTRIBUTE_KEY).get()) == null) continue;
                for (ChannelFuture otherFuture : futures) {
                    if (otherFuture == future) continue;
                    otherFuture.cancel(true);
                    if (!otherFuture.isSuccess()) continue;
                    Channel otherChannel = otherFuture.channel();
                    otherChannel.close();
                }
                if (reconnect) {
                    this.fileRequests.checksums();
                }
                if (whenReconnected != null) {
                    whenReconnected.accept(channel);
                }
                return channel;
            }
            if (whileWaiting != null) {
                whileWaiting.run();
            }
            Thread.yield();
        }
        if (Thread.interrupted()) {
            throw new FileClientConnectInterruptedException("Thread was interrupted during connect");
        }
        return this.createChannelFuture(reconnect, whileWaiting, whenReconnected, Math.min(timeoutNanos + 5000000000L, 30000000000L));
    }

    public Channel connect(boolean reconnect, @Nullable Runnable whileWaiting, @Nullable Consumer<Channel> whenReconnected) {
        Channel channel;
        this.channel = channel = this.createChannelFuture(reconnect, whileWaiting, whenReconnected, 5000000000L);
        return channel;
    }

    public Channel getConnectedChannel() {
        Channel channel = this.channel;
        if (channel == null) {
            return null;
        }
        if (channel.isActive()) {
            return channel;
        }
        return this.connect(true, null, this.whenReconnected);
    }
}

