/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import org.jire.swiftfup.client.FileRequests;
import org.jire.swiftfup.client.codec.HandshakeRequestEncoder;
import org.jire.swiftfup.client.codec.HandshakeResponseDecoder;
import org.jire.swiftfup.client.codec.HandshakeResponseHandler;

public final class FileClientChannelInitializer
extends ChannelInitializer<Channel> {
    public static final String DECODER_HANDLER = "decoder";
    public static final String ENCODER_HANDLER = "encoder";
    public static final String TAIL_HANDLER = "tail";
    private final FileRequests fileRequests;

    public FileClientChannelInitializer(FileRequests fileRequests) {
        this.fileRequests = fileRequests;
    }

    @Override
    protected void initChannel(Channel ch) {
        ChannelPipeline p = ch.pipeline();
        p.addLast(DECODER_HANDLER, (ChannelHandler)new HandshakeResponseDecoder());
        p.addLast(ENCODER_HANDLER, (ChannelHandler)new HandshakeRequestEncoder());
        p.addLast(TAIL_HANDLER, (ChannelHandler)new HandshakeResponseHandler(this.fileRequests));
    }
}

