/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.SocketAddress;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.jire.swiftfup.client.FileClient;
import org.jire.swiftfup.client.FileRequests;

public interface FileClientGroup {
    public EventLoopGroup getEventLoopGroup();

    public Class<? extends Channel> getChannelClass();

    default public FileClient createClient(FileRequests fileRequests, @Nullable Consumer<Channel> whenReconnected, SocketAddress ... remoteAddresses) {
        return new FileClient(fileRequests, this.getEventLoopGroup(), this.getChannelClass(), whenReconnected, remoteAddresses);
    }

    default public EventLoopGroup createEventLoopGroup(int threads) {
        return Epoll.isAvailable() ? new EpollEventLoopGroup(threads) : (KQueue.isAvailable() ? new KQueueEventLoopGroup(threads) : new NioEventLoopGroup(threads));
    }

    default public Class<? extends Channel> createChannelClass(EventLoopGroup group) {
        return group instanceof EpollEventLoopGroup ? EpollSocketChannel.class : (group instanceof KQueueEventLoopGroup ? KQueueSocketChannel.class : NioSocketChannel.class);
    }
}

