/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueue;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.zip.CRC32;
import org.jire.swiftfup.client.FileClient;
import org.jire.swiftfup.client.FileDecompressedListener;
import org.jire.swiftfup.client.FileIndex;
import org.jire.swiftfup.client.FilePair;
import org.jire.swiftfup.client.FileRequest;
import org.jire.swiftfup.client.FileResponse;
import org.jire.swiftfup.client.FileStore;
import org.jire.swiftfup.client.GZIPDecompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileRequests {
    private static final Logger logger = LoggerFactory.getLogger(FileResponse.class);
    private final int capacity;
    private final FileStore fileStore;
    private final Int2IntMap checksums;
    private final Int2ObjectMap<FileRequest> requests;
    private final MessagePassingQueue<FileRequest> pendingRequests;
    private final MessagePassingQueue<FileResponse> completedResponses;
    private final MessagePassingQueue<FileResponse> decompressedResponses;
    private final FileDecompressedListener fileDecompressedListener;
    private volatile boolean ignoreChecksums;
    private static final ThreadLocal<CRC32> threadLocalCRC32 = ThreadLocal.withInitial(CRC32::new);

    public FileRequests(int capacity, FileStore fileStore, FileDecompressedListener fileDecompressedListener) {
        this.capacity = capacity;
        this.fileStore = fileStore;
        this.checksums = new Int2IntOpenHashMap(capacity);
        this.requests = new Int2ObjectOpenHashMap<FileRequest>(capacity);
        this.pendingRequests = new MpscArrayQueue<FileRequest>(capacity);
        this.completedResponses = new MpscArrayQueue<FileResponse>(capacity);
        this.decompressedResponses = new MpscArrayQueue<FileResponse>(capacity);
        this.fileDecompressedListener = fileDecompressedListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileRequest filePair(int filePair) {
        FileResponse response;
        FileRequest request;
        Int2ObjectMap<FileRequest> int2ObjectMap = this.requests;
        synchronized (int2ObjectMap) {
            request = (FileRequest)this.requests.get(filePair);
        }
        if (request == null || filePair == FilePair.CHECKSUMS_FILE_PAIR) {
            request = new FileRequest(filePair);
            int2ObjectMap = this.requests;
            synchronized (int2ObjectMap) {
                this.requests.put(filePair, request);
            }
            this.pendingRequests.offer(request);
        } else if (FilePair.index(filePair) > 0 && (response = (FileResponse)request.getNow(null)) != null) {
            this.fileDecompressedListener.decompressed(response);
        }
        return request;
    }

    public FileRequest file(int index, int file) {
        return this.filePair(FilePair.create(index, file));
    }

    public FileRequest checksums() {
        return this.filePair(FilePair.CHECKSUMS_FILE_PAIR);
    }

    public void process(FileClient fileClient) {
        this.processCompletedResponses();
        this.processPendingRequests(fileClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPendingRequests(FileClient fileClient) {
        FileRequest request;
        boolean reconnected;
        Channel previousChannel = fileClient.getChannel();
        Channel channel = fileClient.getConnectedChannel();
        if (channel == null) {
            return;
        }
        MessagePassingQueue<FileRequest> pendingRequests = this.pendingRequests;
        boolean bl = reconnected = previousChannel != channel;
        if (reconnected) {
            Int2ObjectMap<FileRequest> requests;
            Int2ObjectMap<FileRequest> int2ObjectMap = requests = this.requests;
            synchronized (int2ObjectMap) {
                for (FileRequest value : requests.values()) {
                    if (value.isDone()) continue;
                    pendingRequests.offer(value);
                }
            }
        }
        boolean flush = false;
        while (channel.isActive() && !pendingRequests.isEmpty() && (request = pendingRequests.poll()) != null) {
            byte[] diskData;
            int index;
            if (request.isDone()) continue;
            int filePair = request.getFilePair();
            if (filePair != FilePair.CHECKSUMS_FILE_PAIR && (index = FilePair.index(filePair)) > 0 && this.checksumMatches(filePair, diskData = this.getDiskData(filePair))) {
                FileResponse response = new FileResponse(filePair, diskData);
                this.notifyDecompressed(response);
                request.complete(response);
                continue;
            }
            channel.write(request, channel.voidPromise());
            flush = true;
        }
        if (flush && channel.isActive()) {
            channel.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCompletedResponses() {
        FileResponse response;
        MessagePassingQueue<FileResponse> completedResponses = this.completedResponses;
        Int2ObjectMap<FileRequest> requests = this.requests;
        while (!completedResponses.isEmpty() && (response = completedResponses.poll()) != null) {
            FileRequest request;
            int filePair = response.getFilePair();
            Int2ObjectMap<FileRequest> int2ObjectMap = requests;
            synchronized (int2ObjectMap) {
                request = (FileRequest)requests.get(filePair);
            }
            if (request == null) {
                logger.warn("Request file pair {} was completed, but did not have an initial request", (Object)FilePair.toString(filePair));
                continue;
            }
            request.complete(response);
            if (filePair == FilePair.CHECKSUMS_FILE_PAIR) {
                this.notifyChecksums(response);
                continue;
            }
            int index = FilePair.index(filePair);
            if (index > 0) {
                this.notifyDecompressed(response);
            }
            int file = FilePair.file(filePair);
            byte[] data2 = response.getData();
            if (data2 == null || data2.length <= 0) continue;
            FileIndex fileIndex = this.fileStore.getIndex(index);
            fileIndex.writeFile(file, data2);
        }
    }

    public void processDecompressedResponses() {
        FileResponse response;
        MessagePassingQueue<FileResponse> decompressedResponses = this.decompressedResponses;
        FileDecompressedListener fileDecompressedListener = this.fileDecompressedListener;
        while (!decompressedResponses.isEmpty() && (response = decompressedResponses.poll()) != null) {
            fileDecompressedListener.decompressed(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChecksums(FileResponse response) {
        Int2IntMap checksums;
        Int2IntMap int2IntMap = checksums = this.checksums;
        synchronized (int2IntMap) {
            byte[] compressedBytes = response.getData();
            byte[] decompressedBytes = GZIPDecompressor.getInstance().decompress(compressedBytes);
            ByteBuf data2 = Unpooled.wrappedBuffer(decompressedBytes);
            try {
                int indexCount = data2.readUnsignedByte();
                for (int indexId = 0; indexId < indexCount; ++indexId) {
                    int archiveCount = data2.readUnsignedMedium();
                    for (int archiveId = 0; archiveId < archiveCount; ++archiveId) {
                        int crc32 = data2.readInt();
                        if (crc32 == 0) continue;
                        int filePair = FilePair.create(indexId, archiveId);
                        checksums.put(filePair, crc32);
                    }
                }
            }
            finally {
                data2.release();
            }
        }
    }

    public void notify(FileResponse response) {
        this.completedResponses.offer(response);
    }

    public void notifyDecompressed(FileResponse response) {
        response.setDecompressedData(this.fileStore);
        this.decompressedResponses.offer(response);
    }

    public boolean checksumMatches(int filePair, int checksum) {
        return this.getChecksum(filePair) == checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChecksum(int filePair) {
        Int2IntMap checksums;
        Int2IntMap int2IntMap = checksums = this.checksums;
        synchronized (int2IntMap) {
            return checksums.get(filePair);
        }
    }

    public boolean checksum(int filePair, byte[] data2) {
        return FileRequests.checksumMatchesData(this.getChecksum(filePair), data2);
    }

    public byte[] getDiskData(int filePair) {
        int index = FilePair.index(filePair);
        int file = FilePair.file(filePair);
        FileIndex fileIndex = this.fileStore.getIndex(index);
        return fileIndex == null ? null : fileIndex.getFile(file);
    }

    public boolean isIgnoreChecksums() {
        return this.ignoreChecksums;
    }

    public void setIgnoreChecksums(boolean ignoreChecksums) {
        this.ignoreChecksums = ignoreChecksums;
    }

    public boolean checksumMatches(int filePair, byte[] data2) {
        if (data2 == null) {
            return false;
        }
        if (this.isIgnoreChecksums()) {
            return true;
        }
        int checksum = this.getChecksum(filePair);
        return FileRequests.checksumMatchesData(checksum, data2);
    }

    public static boolean checksumMatchesData(int checksum, byte[] data2) {
        if (data2 == null) {
            return false;
        }
        int dataChecksum = FileRequests.getChecksum(data2);
        return checksum == dataChecksum;
    }

    public static int getChecksum(byte[] data2, CRC32 crc32) {
        if (data2 == null) {
            return 0;
        }
        crc32.reset();
        crc32.update(data2, 0, data2.length);
        return (int)crc32.getValue();
    }

    public static int getChecksum(byte[] data2) {
        return FileRequests.getChecksum(data2, threadLocalCRC32.get());
    }
}

