/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import org.jire.swiftfup.client.FilePair;
import org.jire.swiftfup.client.FileStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileResponse {
    private static final Logger logger = LoggerFactory.getLogger(FileResponse.class);
    private final int filePair;
    private final byte[] data;
    private volatile byte[] decompressedData;

    public FileResponse(int filePair, byte[] data2) {
        this.filePair = filePair;
        this.data = data2;
    }

    public int getFilePair() {
        return this.filePair;
    }

    public int getIndex() {
        return FilePair.index(this.filePair);
    }

    public int getFile() {
        return FilePair.file(this.filePair);
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getDecompressedData() {
        return this.decompressedData;
    }

    public void setDecompressedData(byte[] decompressedData) {
        this.decompressedData = decompressedData;
    }

    public byte[] setDecompressedData(FileStore fileStore) {
        byte[] data2 = this.getData();
        if (data2 == null || data2.length < 1) {
            return null;
        }
        byte[] decompressedData = null;
        try {
            decompressedData = fileStore.decompress(data2);
        }
        catch (Exception e) {
            logger.error("Failed to decompress data of file pair (" + FilePair.toString(this.filePair) + ")", e);
        }
        this.decompressedData = decompressedData;
        return decompressedData;
    }
}

