/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.jire.swiftfup.client.AutoProcessor;
import org.jire.swiftfup.client.AutoProcessorThread;
import org.jire.swiftfup.client.AutoProcessors;
import org.jire.swiftfup.client.FileClient;
import org.jire.swiftfup.client.FileClientGroup;
import org.jire.swiftfup.client.FileDecompressedListener;
import org.jire.swiftfup.client.FileRequests;
import org.jire.swiftfup.client.FileStore;

public final class SwiftFUP {
    public static final int VERSION = 3;
    public static final AutoProcessor DEFAULT_AUTO_PROCESSOR = AutoProcessors.FAST;
    public static final int DEFAULT_EXPECTED_REQUESTS = 524288;
    private final FileStore fileStore;
    private final FileDecompressedListener fileDecompressedListener;
    private final AutoProcessor autoProcessor;
    private final int expectedRequests;
    private FileRequests fileRequests;
    private FileClient fileClient;

    public static long getTimestamp() {
        return System.nanoTime();
    }

    public static SwiftFUP create(FileStore fileStore, FileDecompressedListener fileDecompressedListener, AutoProcessor autoProcessor, int expectedRequests) {
        return new SwiftFUP(fileStore, fileDecompressedListener, autoProcessor, expectedRequests);
    }

    public static SwiftFUP create(FileStore fileStore, FileDecompressedListener fileDecompressedListener) {
        return SwiftFUP.create(fileStore, fileDecompressedListener, DEFAULT_AUTO_PROCESSOR, 524288);
    }

    private SwiftFUP(FileStore fileStore, FileDecompressedListener fileDecompressedListener, AutoProcessor autoProcessor, int expectedRequests) {
        this.fileStore = fileStore;
        this.fileDecompressedListener = fileDecompressedListener;
        this.autoProcessor = autoProcessor;
        this.expectedRequests = expectedRequests;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public FileDecompressedListener getFileDecompressedListener() {
        return this.fileDecompressedListener;
    }

    public AutoProcessor getAutoProcessor() {
        return this.autoProcessor;
    }

    public int getExpectedRequests() {
        return this.expectedRequests;
    }

    public FileRequests getFileRequests() {
        return this.fileRequests;
    }

    public FileClient getFileClient() {
        return this.fileClient;
    }

    public void startAutoProcessor() {
        AutoProcessor autoProcessor = this.autoProcessor;
        if (autoProcessor != null) {
            new AutoProcessorThread(autoProcessor, this.fileClient, this.fileRequests).start();
        }
    }

    public FileRequests initializeFileRequests() {
        this.fileRequests = new FileRequests(this.expectedRequests, this.fileStore, this.fileDecompressedListener);
        return this.fileRequests;
    }

    public FileClient initializeFileClient(FileClientGroup fileClientGroup, @Nullable Runnable whileWaiting, @Nullable Consumer<Channel> whenReconnected, SocketAddress ... remoteAddresses) {
        FileClient fileClient = fileClientGroup.createClient(this.fileRequests, whenReconnected, remoteAddresses);
        fileClient.connect(false, whileWaiting, whenReconnected);
        this.fileClient = fileClient;
        return this.fileClient;
    }
}

