/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.jire.swiftfup.client.FileResponse;

public final class FileResponseDecoder
extends ByteToMessageDecoder {
    private int filePair = -1;
    private int dataSize = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (this.filePair == -1) {
            if (!in.isReadable(7)) {
                return;
            }
            this.filePair = in.readUnsignedMedium();
            this.dataSize = in.readInt();
        }
        if (!in.isReadable(this.dataSize)) {
            return;
        }
        try {
            byte[] data2;
            byte[] byArray = data2 = this.dataSize > 0 ? new byte[this.dataSize] : null;
            if (data2 != null) {
                in.readBytes(data2);
            }
            FileResponse fileResponse = new FileResponse(this.filePair, data2);
            out.add(fileResponse);
        }
        finally {
            this.dataSize = -1;
            this.filePair = -1;
        }
    }
}

