/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import org.jire.swiftfup.client.HandshakeResponse;

public final class HandshakeResponseDecoder
extends ByteToMessageDecoder {
    public static final int NO_STATUS = -1;
    public static final int SUCCESS_STATUS = 0;
    public static final int VERSION_MISMATCH_STATUS = 1;
    private int status = -1;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (this.status == -1) {
            if (!in.isReadable(1)) {
                return;
            }
            this.status = in.readUnsignedByte();
        }
        if (this.status == 0) {
            if (!in.isReadable(3)) {
                return;
            }
        } else {
            if (this.status == 1) {
                throw new DecoderException("Version of server mismatched our version");
            }
            throw new DecoderException("Unknown status received: " + this.status);
        }
        int version = in.readUnsignedMedium();
        out.add(new HandshakeResponse(this.status, version));
    }
}

