/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client.codec;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import org.jire.swiftfup.client.FileRequests;
import org.jire.swiftfup.client.HandshakeRequest;
import org.jire.swiftfup.client.HandshakeResponse;
import org.jire.swiftfup.client.codec.FileRequestEncoder;
import org.jire.swiftfup.client.codec.FileResponseDecoder;
import org.jire.swiftfup.client.codec.FileResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HandshakeResponseHandler
extends SimpleChannelInboundHandler<HandshakeResponse> {
    public static final AttributeKey<HandshakeResponse> HANDSHAKE_RESPONSE_ATTRIBUTE_KEY = AttributeKey.newInstance("HANDSHAKE_RESPONSE");
    private static final Logger logger = LoggerFactory.getLogger(HandshakeResponseHandler.class);
    private final FileRequests fileRequests;

    public HandshakeResponseHandler(FileRequests fileRequests) {
        this.fileRequests = fileRequests;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        ctx.writeAndFlush(new HandshakeRequest(), ctx.voidPromise());
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HandshakeResponse msg) {
        ChannelPipeline p = ctx.pipeline();
        p.replace("decoder", "decoder", (ChannelHandler)new FileResponseDecoder());
        p.replace("encoder", "encoder", (ChannelHandler)new FileRequestEncoder());
        p.replace("tail", "tail", (ChannelHandler)new FileResponseHandler(this.fileRequests));
        ctx.channel().attr(HANDSHAKE_RESPONSE_ATTRIBUTE_KEY).set(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Exception caught", cause);
        ctx.close();
    }
}

