/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class ARMImportMemory {
    public static final int CL_IMPORT_TYPE_ARM = 16562;
    public static final int CL_IMPORT_TYPE_HOST_ARM = 16563;
    public static final int CL_IMPORT_TYPE_DMA_BUF_ARM = 16564;
    public static final int CL_IMPORT_TYPE_PROTECTED_ARM = 16565;
    public static final int CL_IMPORT_TYPE_ANDROID_HARDWARE_BUFFER_ARM = 16866;
    public static final int CL_IMPORT_DMA_BUF_DATA_CONSISTENCY_WITH_HOST_ARM = 16867;
    public static final int CL_IMPORT_ANDROID_HARDWARE_BUFFER_PLANE_INDEX_ARM = 16879;
    public static final int CL_IMPORT_ANDROID_HARDWARE_BUFFER_LAYER_INDEX_ARM = 16880;
    public static final long CL_IMPORT_MEMORY_WHOLE_ALLOCATION_ARM = -1L;

    protected ARMImportMemory() {
        throw new UnsupportedOperationException();
    }

    public static long nclImportMemoryARM(long context, long flags, long properties2, long memory, long size, long errcode_ret) {
        long __functionAddress = CL.getICD().clImportMemoryARM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPJPPPPP(context, flags, properties2, memory, size, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clImportMemoryARM(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @Nullable @NativeType(value="cl_import_properties_arm const *") PointerBuffer properties2, @NativeType(value="void *") ByteBuffer memory, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(properties2);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return ARMImportMemory.nclImportMemoryARM(context, flags, MemoryUtil.memAddressSafe(properties2), MemoryUtil.memAddress(memory), memory.remaining(), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clImportMemoryARM(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @Nullable @NativeType(value="cl_import_properties_arm const *") PointerBuffer properties2, @NativeType(value="void *") ByteBuffer memory, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clImportMemoryARM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkNTSafe(properties2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPP(context, flags, MemoryUtil.memAddressSafe(properties2), MemoryUtil.memAddress(memory), (long)memory.remaining(), errcode_ret, __functionAddress);
    }
}

