/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class KHRCommandBuffer {
    public static final int CL_DEVICE_COMMAND_BUFFER_CAPABILITIES_KHR = 4777;
    public static final int CL_DEVICE_COMMAND_BUFFER_REQUIRED_QUEUE_PROPERTIES_KHR = 4778;
    public static final int CL_COMMAND_BUFFER_CAPABILITY_KERNEL_PRINTF_KHR = 1;
    public static final int CL_COMMAND_BUFFER_CAPABILITY_DEVICE_SIDE_ENQUEUE_KHR = 2;
    public static final int CL_COMMAND_BUFFER_CAPABILITY_SIMULTANEOUS_USE_KHR = 4;
    public static final int CL_COMMAND_BUFFER_CAPABILITY_OUT_OF_ORDER_KHR = 8;
    public static final int CL_COMMAND_BUFFER_STATE_RECORDING_KHR = 0;
    public static final int CL_COMMAND_BUFFER_STATE_EXECUTABLE_KHR = 1;
    public static final int CL_COMMAND_BUFFER_STATE_PENDING_KHR = 2;
    public static final int CL_COMMAND_BUFFER_STATE_INVALID_KHR = 3;
    public static final int CL_INVALID_COMMAND_BUFFER_KHR = -1138;
    public static final int CL_INVALID_SYNC_POINT_WAIT_LIST_KHR = -1139;
    public static final int CL_INCOMPATIBLE_COMMAND_QUEUE_KHR = -1140;
    public static final int CL_COMMAND_BUFFER_FLAGS_KHR = 4755;
    public static final int CL_COMMAND_BUFFER_SIMULTANEOUS_USE_KHR = 1;
    public static final int CL_COMMAND_BUFFER_QUEUES_KHR = 4756;
    public static final int CL_COMMAND_BUFFER_NUM_QUEUES_KHR = 4757;
    public static final int CL_COMMAND_BUFFER_REFERENCE_COUNT_KHR = 4758;
    public static final int CL_COMMAND_BUFFER_STATE_KHR = 4759;
    public static final int CL_COMMAND_BUFFER_PROPERTIES_ARRAY_KHR = 4760;
    public static final int CL_COMMAND_COMMAND_BUFFER_KHR = 4776;

    protected KHRCommandBuffer() {
        throw new UnsupportedOperationException();
    }

    public static long nclCreateCommandBufferKHR(int num_queues, long queues, long properties2, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateCommandBufferKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPP(num_queues, queues, properties2, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_command_buffer_khr")
    public static long clCreateCommandBufferKHR(@NativeType(value="cl_command_queue const *") PointerBuffer queues, @Nullable @NativeType(value="cl_command_buffer_properties_khr const *") LongBuffer properties2, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(properties2);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return KHRCommandBuffer.nclCreateCommandBufferKHR(queues.remaining(), MemoryUtil.memAddress(queues), MemoryUtil.memAddressSafe(properties2), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainCommandBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer) {
        long __functionAddress = CL.getICD().clRetainCommandBufferKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
        }
        return JNI.callPI(command_buffer, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseCommandBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer) {
        long __functionAddress = CL.getICD().clReleaseCommandBufferKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
        }
        return JNI.callPI(command_buffer, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clFinalizeCommandBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer) {
        long __functionAddress = CL.getICD().clFinalizeCommandBufferKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
        }
        return JNI.callPI(command_buffer, __functionAddress);
    }

    public static int nclEnqueueCommandBufferKHR(int num_queues, long queues, long command_buffer, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueCommandBufferKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
        }
        return JNI.callPPPPI(num_queues, queues, command_buffer, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueCommandBufferKHR(@Nullable @NativeType(value="cl_command_queue *") PointerBuffer queues, @NativeType(value="cl_command_buffer_khr") long command_buffer, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return KHRCommandBuffer.nclEnqueueCommandBufferKHR(Checks.remainingSafe(queues), MemoryUtil.memAddressSafe(queues), command_buffer, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclCommandBarrierWithWaitListKHR(long command_buffer, long command_queue, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandBarrierWithWaitListKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
        }
        return JNI.callPPPPPI(command_buffer, command_queue, num_sync_points_in_wait_list, sync_point_wait_list, sync_point, mutable_handle, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandBarrierWithWaitListKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @Nullable @NativeType(value="cl_sync_point_khr const *") IntBuffer sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") IntBuffer sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return KHRCommandBuffer.nclCommandBarrierWithWaitListKHR(command_buffer, command_queue, Checks.remainingSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point), MemoryUtil.memAddressSafe(mutable_handle));
    }

    public static int nclCommandCopyBufferKHR(long command_buffer, long command_queue, long src_buffer, long dst_buffer, long src_offset, long dst_offset, long size, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyBufferKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(src_buffer);
            Checks.check(dst_buffer);
        }
        return JNI.callPPPPPPPPPPI(command_buffer, command_queue, src_buffer, dst_buffer, src_offset, dst_offset, size, num_sync_points_in_wait_list, sync_point_wait_list, sync_point, mutable_handle, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t") long src_offset, @NativeType(value="size_t") long dst_offset, @NativeType(value="size_t") long size, @Nullable @NativeType(value="cl_sync_point_khr const *") IntBuffer sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") IntBuffer sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return KHRCommandBuffer.nclCommandCopyBufferKHR(command_buffer, command_queue, src_buffer, dst_buffer, src_offset, dst_offset, size, Checks.remainingSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point), MemoryUtil.memAddressSafe(mutable_handle));
    }

    public static int nclCommandCopyBufferRectKHR(long command_buffer, long command_queue, long src_buffer, long dst_buffer, long src_origin, long dst_origin, long region, long src_row_pitch, long src_slice_pitch, long dst_row_pitch, long dst_slice_pitch, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyBufferRectKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(src_buffer);
            Checks.check(dst_buffer);
        }
        return JNI.callPPPPPPPPPPPPPPI(command_buffer, command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region, src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_sync_points_in_wait_list, sync_point_wait_list, sync_point, mutable_handle, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyBufferRectKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long src_row_pitch, @NativeType(value="size_t") long src_slice_pitch, @NativeType(value="size_t") long dst_row_pitch, @NativeType(value="size_t") long dst_slice_pitch, @Nullable @NativeType(value="cl_sync_point_khr const *") IntBuffer sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") IntBuffer sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check(src_origin, 3);
            Checks.check(dst_origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe((Buffer)sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return KHRCommandBuffer.nclCommandCopyBufferRectKHR(command_buffer, command_queue, src_buffer, dst_buffer, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, Checks.remainingSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point), MemoryUtil.memAddressSafe(mutable_handle));
    }

    public static int nclCommandCopyBufferToImageKHR(long command_buffer, long command_queue, long src_buffer, long dst_image, long src_offset, long dst_origin, long region, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyBufferToImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(src_buffer);
            Checks.check(dst_image);
        }
        return JNI.callPPPPPPPPPPI(command_buffer, command_queue, src_buffer, dst_image, src_offset, dst_origin, region, num_sync_points_in_wait_list, sync_point_wait_list, sync_point, mutable_handle, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyBufferToImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_image, @NativeType(value="size_t") long src_offset, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_sync_point_khr const *") IntBuffer sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") IntBuffer sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check(dst_origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe((Buffer)sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return KHRCommandBuffer.nclCommandCopyBufferToImageKHR(command_buffer, command_queue, src_buffer, dst_image, src_offset, MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), Checks.remainingSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point), MemoryUtil.memAddressSafe(mutable_handle));
    }

    public static int nclCommandCopyImageKHR(long command_buffer, long command_queue, long src_image, long dst_image, long src_origin, long dst_origin, long region, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(src_image);
            Checks.check(dst_image);
        }
        return JNI.callPPPPPPPPPPI(command_buffer, command_queue, src_image, dst_image, src_origin, dst_origin, region, num_sync_points_in_wait_list, sync_point_wait_list, sync_point, mutable_handle, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_image, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_sync_point_khr const *") IntBuffer sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") IntBuffer sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check(src_origin, 3);
            Checks.check(dst_origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe((Buffer)sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return KHRCommandBuffer.nclCommandCopyImageKHR(command_buffer, command_queue, src_image, dst_image, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), Checks.remainingSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point), MemoryUtil.memAddressSafe(mutable_handle));
    }

    public static int nclCommandCopyImageToBufferKHR(long command_buffer, long command_queue, long src_image, long dst_buffer, long src_origin, long region, long dst_offset, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyImageToBufferKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(src_image);
            Checks.check(dst_buffer);
        }
        return JNI.callPPPPPPPPPPI(command_buffer, command_queue, src_image, dst_buffer, src_origin, region, dst_offset, num_sync_points_in_wait_list, sync_point_wait_list, sync_point, mutable_handle, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyImageToBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long dst_offset, @Nullable @NativeType(value="cl_sync_point_khr const *") IntBuffer sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") IntBuffer sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check(src_origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe((Buffer)sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return KHRCommandBuffer.nclCommandCopyImageToBufferKHR(command_buffer, command_queue, src_image, dst_buffer, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(region), dst_offset, Checks.remainingSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point), MemoryUtil.memAddressSafe(mutable_handle));
    }

    public static int nclCommandFillBufferKHR(long command_buffer, long command_queue, long buffer, long pattern, long pattern_size, long offset, long size, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandFillBufferKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(buffer);
        }
        return JNI.callPPPPPPPPPPI(command_buffer, command_queue, buffer, pattern, pattern_size, offset, size, num_sync_points_in_wait_list, sync_point_wait_list, sync_point, mutable_handle, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandFillBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="void const *") ByteBuffer pattern, @NativeType(value="size_t") long offset, @NativeType(value="size_t") long size, @Nullable @NativeType(value="cl_sync_point_khr const *") IntBuffer sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") IntBuffer sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return KHRCommandBuffer.nclCommandFillBufferKHR(command_buffer, command_queue, buffer, MemoryUtil.memAddress(pattern), pattern.remaining(), offset, size, Checks.remainingSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point), MemoryUtil.memAddressSafe(mutable_handle));
    }

    public static int nclCommandFillImageKHR(long command_buffer, long command_queue, long image, long fill_color, long origin, long region, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandFillImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(image);
        }
        return JNI.callPPPPPPPPPI(command_buffer, command_queue, image, fill_color, origin, region, num_sync_points_in_wait_list, sync_point_wait_list, sync_point, mutable_handle, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandFillImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") ByteBuffer fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_sync_point_khr const *") IntBuffer sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") IntBuffer sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)fill_color, 16);
            Checks.check(origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe((Buffer)sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return KHRCommandBuffer.nclCommandFillImageKHR(command_buffer, command_queue, image, MemoryUtil.memAddress(fill_color), MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), Checks.remainingSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point), MemoryUtil.memAddressSafe(mutable_handle));
    }

    @NativeType(value="cl_int")
    public static int clCommandFillImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") IntBuffer fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_sync_point_khr const *") IntBuffer sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") IntBuffer sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)fill_color, 4);
            Checks.check(origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe((Buffer)sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return KHRCommandBuffer.nclCommandFillImageKHR(command_buffer, command_queue, image, MemoryUtil.memAddress(fill_color), MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), Checks.remainingSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point), MemoryUtil.memAddressSafe(mutable_handle));
    }

    @NativeType(value="cl_int")
    public static int clCommandFillImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") FloatBuffer fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_sync_point_khr const *") IntBuffer sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") IntBuffer sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)fill_color, 4);
            Checks.check(origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe((Buffer)sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return KHRCommandBuffer.nclCommandFillImageKHR(command_buffer, command_queue, image, MemoryUtil.memAddress(fill_color), MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), Checks.remainingSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point), MemoryUtil.memAddressSafe(mutable_handle));
    }

    public static int nclCommandNDRangeKernelKHR(long command_buffer, long command_queue, long properties2, long kernel, int work_dim, long global_work_offset, long global_work_size, long local_work_size, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandNDRangeKernelKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(kernel);
        }
        return JNI.callPPPPPPPPPPI(command_buffer, command_queue, properties2, kernel, work_dim, global_work_offset, global_work_size, local_work_size, num_sync_points_in_wait_list, sync_point_wait_list, sync_point, mutable_handle, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandNDRangeKernelKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @Nullable @NativeType(value="cl_ndrange_kernel_command_properties_khr const *") LongBuffer properties2, @NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int work_dim, @Nullable @NativeType(value="size_t const *") PointerBuffer global_work_offset, @Nullable @NativeType(value="size_t const *") PointerBuffer global_work_size, @Nullable @NativeType(value="size_t const *") PointerBuffer local_work_size, @Nullable @NativeType(value="cl_sync_point_khr const *") IntBuffer sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") IntBuffer sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(properties2);
            Checks.checkSafe(global_work_offset, work_dim);
            Checks.checkSafe(global_work_size, work_dim);
            Checks.checkSafe(local_work_size, work_dim);
            Checks.checkSafe((Buffer)sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return KHRCommandBuffer.nclCommandNDRangeKernelKHR(command_buffer, command_queue, MemoryUtil.memAddressSafe(properties2), kernel, work_dim, MemoryUtil.memAddressSafe(global_work_offset), MemoryUtil.memAddressSafe(global_work_size), MemoryUtil.memAddressSafe(local_work_size), Checks.remainingSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point_wait_list), MemoryUtil.memAddressSafe(sync_point), MemoryUtil.memAddressSafe(mutable_handle));
    }

    public static int nclGetCommandBufferInfoKHR(long command_buffer, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetCommandBufferInfoKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
        }
        return JNI.callPPPPI(command_buffer, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetCommandBufferInfoKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_buffer_info_khr") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return KHRCommandBuffer.nclGetCommandBufferInfoKHR(command_buffer, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetCommandBufferInfoKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_buffer_info_khr") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return KHRCommandBuffer.nclGetCommandBufferInfoKHR(command_buffer, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetCommandBufferInfoKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_buffer_info_khr") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return KHRCommandBuffer.nclGetCommandBufferInfoKHR(command_buffer, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_command_buffer_khr")
    public static long clCreateCommandBufferKHR(@NativeType(value="cl_command_queue const *") PointerBuffer queues, @Nullable @NativeType(value="cl_command_buffer_properties_khr const *") long[] properties2, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateCommandBufferKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkNTSafe(properties2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPP(queues.remaining(), MemoryUtil.memAddress(queues), properties2, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandBarrierWithWaitListKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @Nullable @NativeType(value="cl_sync_point_khr const *") int[] sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") int[] sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandBarrierWithWaitListKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.checkSafe(sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return JNI.callPPPPPI(command_buffer, command_queue, Checks.lengthSafe(sync_point_wait_list), sync_point_wait_list, sync_point, MemoryUtil.memAddressSafe(mutable_handle), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t") long src_offset, @NativeType(value="size_t") long dst_offset, @NativeType(value="size_t") long size, @Nullable @NativeType(value="cl_sync_point_khr const *") int[] sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") int[] sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyBufferKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(src_buffer);
            Checks.check(dst_buffer);
            Checks.checkSafe(sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return JNI.callPPPPPPPPPPI(command_buffer, command_queue, src_buffer, dst_buffer, src_offset, dst_offset, size, Checks.lengthSafe(sync_point_wait_list), sync_point_wait_list, sync_point, MemoryUtil.memAddressSafe(mutable_handle), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyBufferRectKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long src_row_pitch, @NativeType(value="size_t") long src_slice_pitch, @NativeType(value="size_t") long dst_row_pitch, @NativeType(value="size_t") long dst_slice_pitch, @Nullable @NativeType(value="cl_sync_point_khr const *") int[] sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") int[] sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyBufferRectKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(src_buffer);
            Checks.check(dst_buffer);
            Checks.check(src_origin, 3);
            Checks.check(dst_origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe(sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return JNI.callPPPPPPPPPPPPPPI(command_buffer, command_queue, src_buffer, dst_buffer, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, Checks.lengthSafe(sync_point_wait_list), sync_point_wait_list, sync_point, MemoryUtil.memAddressSafe(mutable_handle), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyBufferToImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_image, @NativeType(value="size_t") long src_offset, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_sync_point_khr const *") int[] sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") int[] sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyBufferToImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(src_buffer);
            Checks.check(dst_image);
            Checks.check(dst_origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe(sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return JNI.callPPPPPPPPPPI(command_buffer, command_queue, src_buffer, dst_image, src_offset, MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), Checks.lengthSafe(sync_point_wait_list), sync_point_wait_list, sync_point, MemoryUtil.memAddressSafe(mutable_handle), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_image, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_sync_point_khr const *") int[] sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") int[] sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(src_image);
            Checks.check(dst_image);
            Checks.check(src_origin, 3);
            Checks.check(dst_origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe(sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return JNI.callPPPPPPPPPPI(command_buffer, command_queue, src_image, dst_image, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), Checks.lengthSafe(sync_point_wait_list), sync_point_wait_list, sync_point, MemoryUtil.memAddressSafe(mutable_handle), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyImageToBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long dst_offset, @Nullable @NativeType(value="cl_sync_point_khr const *") int[] sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") int[] sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyImageToBufferKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(src_image);
            Checks.check(dst_buffer);
            Checks.check(src_origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe(sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return JNI.callPPPPPPPPPPI(command_buffer, command_queue, src_image, dst_buffer, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(region), dst_offset, Checks.lengthSafe(sync_point_wait_list), sync_point_wait_list, sync_point, MemoryUtil.memAddressSafe(mutable_handle), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandFillBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="void const *") ByteBuffer pattern, @NativeType(value="size_t") long offset, @NativeType(value="size_t") long size, @Nullable @NativeType(value="cl_sync_point_khr const *") int[] sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") int[] sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandFillBufferKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(buffer);
            Checks.checkSafe(sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return JNI.callPPPPPPPPPPI(command_buffer, command_queue, buffer, MemoryUtil.memAddress(pattern), (long)pattern.remaining(), offset, size, Checks.lengthSafe(sync_point_wait_list), sync_point_wait_list, sync_point, MemoryUtil.memAddressSafe(mutable_handle), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandFillImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") ByteBuffer fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_sync_point_khr const *") int[] sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") int[] sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandFillImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(image);
            Checks.check((Buffer)fill_color, 16);
            Checks.check(origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe(sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return JNI.callPPPPPPPPPI(command_buffer, command_queue, image, MemoryUtil.memAddress(fill_color), MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), Checks.lengthSafe(sync_point_wait_list), sync_point_wait_list, sync_point, MemoryUtil.memAddressSafe(mutable_handle), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandFillImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") int[] fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_sync_point_khr const *") int[] sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") int[] sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandFillImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(image);
            Checks.check(fill_color, 4);
            Checks.check(origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe(sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return JNI.callPPPPPPPPPI(command_buffer, command_queue, image, fill_color, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), Checks.lengthSafe(sync_point_wait_list), sync_point_wait_list, sync_point, MemoryUtil.memAddressSafe(mutable_handle), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandFillImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") float[] fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_sync_point_khr const *") int[] sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") int[] sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandFillImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.check(image);
            Checks.check(fill_color, 4);
            Checks.check(origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe(sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return JNI.callPPPPPPPPPI(command_buffer, command_queue, image, fill_color, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), Checks.lengthSafe(sync_point_wait_list), sync_point_wait_list, sync_point, MemoryUtil.memAddressSafe(mutable_handle), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandNDRangeKernelKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @Nullable @NativeType(value="cl_ndrange_kernel_command_properties_khr const *") long[] properties2, @NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int work_dim, @Nullable @NativeType(value="size_t const *") PointerBuffer global_work_offset, @Nullable @NativeType(value="size_t const *") PointerBuffer global_work_size, @Nullable @NativeType(value="size_t const *") PointerBuffer local_work_size, @Nullable @NativeType(value="cl_sync_point_khr const *") int[] sync_point_wait_list, @Nullable @NativeType(value="cl_sync_point_khr *") int[] sync_point, @Nullable @NativeType(value="cl_mutable_command_khr *") PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandNDRangeKernelKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.checkNTSafe(properties2);
            Checks.check(kernel);
            Checks.checkSafe(global_work_offset, work_dim);
            Checks.checkSafe(global_work_size, work_dim);
            Checks.checkSafe(local_work_size, work_dim);
            Checks.checkSafe(sync_point, 1);
            Checks.checkSafe(mutable_handle, 1);
        }
        return JNI.callPPPPPPPPPPI(command_buffer, command_queue, properties2, kernel, work_dim, MemoryUtil.memAddressSafe(global_work_offset), MemoryUtil.memAddressSafe(global_work_size), MemoryUtil.memAddressSafe(local_work_size), Checks.lengthSafe(sync_point_wait_list), sync_point_wait_list, sync_point, MemoryUtil.memAddressSafe(mutable_handle), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetCommandBufferInfoKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_buffer_info_khr") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetCommandBufferInfoKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_buffer);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(command_buffer, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }
}

