/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.intellij;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import org.pushingpixels.substance.internal.contrib.jgoodies.looks.LookUtils;

public class UIUtil {
    private static Double cachedScaleFactorReply = null;

    public static double getScaleFactor(Graphics2D graphics) {
        return DetectRetinaKit.getScaleFactor(graphics);
    }

    public static double getScaleFactor() {
        if (cachedScaleFactorReply != null) {
            return cachedScaleFactorReply;
        }
        double result2 = 1.0;
        result2 = GraphicsEnvironment.isHeadless() ? 1.0 : DetectRetinaKit.getScaleFactor();
        cachedScaleFactorReply = result2;
        return cachedScaleFactorReply;
    }

    private static final class DetectRetinaKit {
        private static final WeakHashMap<GraphicsDevice, Double> devicesScaleFactorCacheMap = new WeakHashMap();

        private DetectRetinaKit() {
        }

        private static double getScaleFactorModern(GraphicsDevice device) {
            GraphicsConfiguration graphicsConfig = device.getDefaultConfiguration();
            AffineTransform tx = graphicsConfig.getDefaultTransform();
            double scaleX = tx.getScaleX();
            double scaleY = tx.getScaleY();
            return Math.max(scaleX, scaleY);
        }

        private static double getScaleFactorLegacy(GraphicsDevice device) {
            try {
                Method getScaleFactorMethod = Class.forName("sun.awt.CGraphicsDevice").getMethod("getScaleFactor", new Class[0]);
                if (getScaleFactorMethod == null) {
                    return 1.0;
                }
                int result2 = (Integer)getScaleFactorMethod.invoke((Object)device, new Object[0]);
                if (result2 <= 0) {
                    return 1.0;
                }
                return result2;
            }
            catch (Throwable t2) {
                return 1.0;
            }
        }

        private static double getScaleFactor(GraphicsDevice device) {
            if (LookUtils.IS_VENDOR_APPLE) {
                return 1.0;
            }
            if (devicesScaleFactorCacheMap.containsKey(device)) {
                return devicesScaleFactorCacheMap.get(device);
            }
            double result2 = LookUtils.IS_JAVA_9 || LookUtils.IS_JAVA_10 ? DetectRetinaKit.getScaleFactorModern(device) : DetectRetinaKit.getScaleFactorLegacy(device);
            devicesScaleFactorCacheMap.put(device, result2);
            return result2;
        }

        private static double getScaleFactor(Graphics2D g2) {
            GraphicsDevice device = g2.getDeviceConfiguration().getDevice();
            return DetectRetinaKit.getScaleFactor(device);
        }

        private static double getScaleFactor() {
            GraphicsDevice[] devices;
            if (LookUtils.IS_VENDOR_APPLE) {
                return 1.0;
            }
            double result2 = 1.0;
            GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice device : devices = e.getScreenDevices()) {
                result2 = Math.max(result2, DetectRetinaKit.getScaleFactor(device));
            }
            return result2;
        }
    }
}

