/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.renderer.SubstanceDefaultComboBoxRenderer;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.RolloverTextControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceDropDownButton;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;
import org.pushingpixels.substance.internal.utils.combo.ComboBoxBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.combo.SubstanceComboBoxEditor;
import org.pushingpixels.substance.internal.utils.combo.SubstanceComboPopup;
import org.pushingpixels.substance.internal.utils.filters.RenderingUtils;

public class SubstanceComboBoxUI
extends BasicComboBoxUI
implements TransitionAwareUI {
    protected ComboBoxPropertyChangeHandler substanceChangeHandler;
    protected StateTransitionTracker stateTransitionTracker;
    private ButtonModel transitionModel;
    private RolloverTextControlListener substanceRolloverListener;
    private ComboBoxBackgroundDelegate delegate;
    private Icon uneditableArrowIcon;
    private Insets layoutInsets;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        SubstanceComboBoxUI ui = new SubstanceComboBoxUI((JComboBox)comp);
        ui.comboBox = (JComboBox)comp;
        ui.comboBox.setOpaque(false);
        return ui;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("substancelaf.internal.textComponentAware", new SubstanceCoreUtilities.TextComponentAware<JComboBox>(){

            @Override
            public JTextComponent getTextComponent(JComboBox t2) {
                Component editorComp;
                if (t2.isEditable() && (editorComp = t2.getEditor().getEditorComponent()) instanceof JTextComponent) {
                    return (JTextComponent)editorComp;
                }
                return null;
            }
        });
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.putClientProperty("substancelaf.internal.textComponentAware", null);
        super.uninstallUI(c);
    }

    public SubstanceComboBoxUI(JComboBox combo) {
        this.comboBox = combo;
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(combo.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(this.comboBox, this.transitionModel);
        this.delegate = new ComboBoxBackgroundDelegate();
    }

    @Override
    protected JButton createArrowButton() {
        SubstanceDropDownButton result2 = new SubstanceDropDownButton(this.comboBox);
        result2.setFont(this.comboBox.getFont());
        result2.setIcon(this.getCurrentIcon(result2));
        return result2;
    }

    private Icon getCurrentIcon(JButton button) {
        int popupFlyoutOrientation = SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox);
        Icon icon = SubstanceCoreUtilities.getArrowIcon(button, popupFlyoutOrientation);
        return icon;
    }

    protected ListCellRenderer createRenderer() {
        return new SubstanceDefaultComboBoxRenderer.SubstanceUIResource(this.comboBox);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceChangeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.substanceChangeHandler);
        this.substanceRolloverListener = new RolloverTextControlListener(this.comboBox, this, this.transitionModel);
        this.substanceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
    }

    @Override
    protected void uninstallListeners() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.comboBox.removePropertyChangeListener(this.substanceChangeHandler);
        this.substanceChangeHandler = null;
        this.substanceRolloverListener.unregisterListeners();
        this.substanceRolloverListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.uneditableArrowIcon = SubstanceCoreUtilities.getArrowIcon(this.comboBox, () -> (TransitionAwareUI)((Object)this.comboBox.getUI()), SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox));
        this.updateComboBoxBorder();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new SubstanceComboBoxLayoutManager();
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.layoutInsets;
        int buttonWidth = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(this.comboBox));
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, width - insets.left - insets.right - buttonWidth, height - insets.top - insets.bottom);
        }
        int startX = insets.left + buttonWidth;
        return new Rectangle(startX, insets.top, width - startX - insets.right, height - insets.top - insets.bottom);
    }

    @Override
    protected Dimension getDefaultSize() {
        Component rend = new SubstanceDefaultComboBoxRenderer(this.comboBox).getListCellRendererComponent(this.listBox, (Object)" ", -1, false, false);
        rend.setFont(this.comboBox.getFont());
        return rend.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        SubstanceDropDownButton button = (SubstanceDropDownButton)this.arrowButton;
        Insets buttonInsets = button.getInsets();
        Insets insets = this.comboBox.getInsets();
        Dimension size = this.getDisplaySize();
        size.width += insets.left + insets.right;
        size.width += buttonInsets.left + buttonInsets.right;
        size.width = (int)((double)size.width + button.getMinimumSize().getWidth());
        size.height += insets.top + insets.bottom;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    protected ComboPopup createPopup() {
        SubstanceComboPopup sPopup = new SubstanceComboPopup(this.comboBox);
        ComponentOrientation currOrientation = this.comboBox.getComponentOrientation();
        SwingUtilities.invokeLater(() -> {
            ComboBoxEditor editor;
            ListCellRenderer cellRenderer;
            if (this.comboBox == null) {
                return;
            }
            if (sPopup instanceof Component) {
                Component cPopup = (Component)((Object)sPopup);
                cPopup.applyComponentOrientation(currOrientation);
                cPopup.doLayout();
            }
            if ((cellRenderer = this.comboBox.getRenderer()) instanceof Component) {
                ((Component)((Object)cellRenderer)).applyComponentOrientation(currOrientation);
            }
            if ((editor = this.comboBox.getEditor()) != null && editor.getEditorComponent() != null) {
                editor.getEditorComponent().applyComponentOrientation(currOrientation);
            }
            this.comboBox.repaint();
        });
        return sPopup;
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        Rectangle r;
        Graphics2D graphics = (Graphics2D)g2.create();
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.comboBox.getInsets();
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
        if (this.comboBox.isEditable()) {
            SubstanceTextUtilities.paintTextCompBackground(g2, c);
        } else {
            this.delegate.updateBackground(graphics, this.comboBox, this.transitionModel);
            Icon icon = this.uneditableArrowIcon;
            int iw = icon.getIconWidth();
            int ih = icon.getIconHeight();
            int origButtonWidth = SubstanceSizeUtils.getScrollBarWidth(componentFontSize);
            Graphics2D forIcon = (Graphics2D)graphics.create();
            forIcon.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            int iconY = 1 + insets.top + (height - insets.top - insets.bottom - ih) / 2;
            if (this.comboBox.getComponentOrientation().isLeftToRight()) {
                int iconX = width - origButtonWidth - insets.right / 2 + (origButtonWidth - iw) / 2;
                forIcon.translate(iconX, iconY);
                icon.paintIcon(this.comboBox, forIcon, 0, 0);
            } else {
                int iconX = insets.left / 2 + (origButtonWidth - iw) / 2;
                forIcon.translate(iconX, iconY);
                icon.paintIcon(this.comboBox, forIcon, 0, 0);
            }
            forIcon.dispose();
        }
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            r = this.rectangleForCurrentValue();
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            Component rendererComponent = this.hasFocus ? renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, this.hasFocus) : renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, this.hasFocus);
            rendererComponent.setFont(this.comboBox.getFont());
            boolean shouldValidate = false;
            if (rendererComponent instanceof JPanel) {
                shouldValidate = true;
            }
            if (this.comboBox.getComponentOrientation().isLeftToRight()) {
                this.currentValuePane.paintComponent(graphics, rendererComponent, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
            } else {
                this.currentValuePane.paintComponent(graphics, rendererComponent, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
            }
        }
        if (!this.comboBox.isEditable()) {
            r = new Rectangle(insets.left, this.layoutInsets.top, width - insets.left - insets.right, height - this.layoutInsets.top - this.layoutInsets.bottom);
            this.paintFocus(graphics, r);
        }
        graphics.dispose();
    }

    protected void paintFocus(Graphics g2, Rectangle bounds) {
        int fontSize = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
        int x = bounds.x;
        int y = bounds.y;
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.translate(x, y);
        SubstanceCoreUtilities.paintFocus(g2d, this.comboBox, this.comboBox, this, SubstanceOutlineUtilities.getBaseOutline(bounds.width, bounds.height, SubstanceSizeUtils.getClassicButtonCornerRadius(fontSize), null, 0.0f), bounds, 1.0f, 0.0f);
        g2d.dispose();
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    @Override
    public void configureArrowButton() {
        super.configureArrowButton();
        this.arrowButton.setFocusable(false);
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (this.editor instanceof JComponent) {
            Insets ins = SubstanceSizeUtils.getComboTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.editor));
            ((JComponent)this.editor).setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
            this.editor.setBackground(this.comboBox.getBackground());
        }
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new SubstanceComboBoxEditor.UIResource();
    }

    private void updateComboBoxBorder() {
        Border b = this.comboBox.getBorder();
        if (b == null || b instanceof UIResource) {
            int comboFontSize = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
            Insets comboBorderInsets = SubstanceSizeUtils.getComboBorderInsets(comboFontSize);
            if (this.comboBox.isEditable()) {
                SubstanceTextComponentBorder border = new SubstanceTextComponentBorder(comboBorderInsets);
                this.comboBox.setBorder(border);
            } else {
                this.comboBox.setBorder(new BorderUIResource.EmptyBorderUIResource(comboBorderInsets));
                this.comboBox.setPrototypeDisplayValue(this.comboBox.getPrototypeDisplayValue());
            }
            this.layoutInsets = SubstanceSizeUtils.getComboLayoutInsets(comboFontSize);
        } else {
            this.layoutInsets = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent me) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return false;
        }
        ClassicButtonShaper shaper = ClassicButtonShaper.INSTANCE;
        if (shaper == null) {
            return false;
        }
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(this.comboBox, SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.comboBox)), null);
        return contour.contains(me.getPoint());
    }

    @Override
    public void update(Graphics g2, JComponent c) {
        Graphics2D g2d = (Graphics2D)g2.create();
        RenderingUtils.installDesktopHints(g2d, c);
        this.paint(g2d, c);
        g2d.dispose();
    }

    public class ComboBoxPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public ComboBoxPropertyChangeHandler() {
            super(SubstanceComboBoxUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("componentOrientation")) {
                SwingUtilities.invokeLater(() -> {
                    if (SubstanceComboBoxUI.this.comboBox == null) {
                        return;
                    }
                    ComponentOrientation newOrientation = (ComponentOrientation)e.getNewValue();
                    ListCellRenderer cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer();
                    ComboBoxEditor editor = SubstanceComboBoxUI.this.comboBox.getEditor();
                    if (SubstanceComboBoxUI.this.popup instanceof Component) {
                        Component cPopup = (Component)((Object)SubstanceComboBoxUI.this.popup);
                        cPopup.applyComponentOrientation(newOrientation);
                        cPopup.doLayout();
                    }
                    if (cellRenderer instanceof Component) {
                        ((Component)((Object)cellRenderer)).applyComponentOrientation(newOrientation);
                    }
                    if (editor != null && editor.getEditorComponent() != null) {
                        editor.getEditorComponent().applyComponentOrientation(newOrientation);
                    }
                    if (SubstanceComboBoxUI.this.comboBox != null) {
                        SubstanceComboBoxUI.this.comboBox.repaint();
                    }
                });
            }
            if ("substancelaf.internal.comboBoxPopupFlyoutOrientation".equals(propertyName)) {
                SubstanceDropDownButton dropDownButton = (SubstanceDropDownButton)SubstanceComboBoxUI.this.arrowButton;
                dropDownButton.setIcon(SubstanceComboBoxUI.this.getCurrentIcon(dropDownButton));
                SubstanceComboBoxUI.this.uneditableArrowIcon = SubstanceCoreUtilities.getArrowIcon(SubstanceComboBoxUI.this.comboBox, () -> (TransitionAwareUI)((Object)SubstanceComboBoxUI.this.comboBox.getUI()), SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox));
            }
            if ("font".equals(propertyName)) {
                SwingUtilities.invokeLater(() -> {
                    if (SubstanceComboBoxUI.this.comboBox != null) {
                        SubstanceComboBoxUI.this.comboBox.updateUI();
                    }
                });
            }
            if ("background".equals(propertyName) && SubstanceComboBoxUI.this.comboBox.isEditable()) {
                SubstanceComboBoxUI.this.comboBox.getEditor().getEditorComponent().setBackground(SubstanceComboBoxUI.this.comboBox.getBackground());
                SubstanceComboBoxUI.this.popup.getList().setBackground(SubstanceComboBoxUI.this.comboBox.getBackground());
            }
            if ("editable".equals(propertyName)) {
                SubstanceComboBoxUI.this.updateComboBoxBorder();
                SubstanceComboBoxUI.this.isMinimumSizeDirty = true;
            }
            if ("enabled".equals(propertyName)) {
                SubstanceComboBoxUI.this.transitionModel.setEnabled(SubstanceComboBoxUI.this.comboBox.isEnabled());
            }
        }
    }

    private class SubstanceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private SubstanceComboBoxLayoutManager() {
            super(SubstanceComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonWidth;
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = SubstanceComboBoxUI.this.layoutInsets;
            int n = buttonWidth = SubstanceComboBoxUI.this.comboBox.isEditable() ? SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(SubstanceComboBoxUI.this.comboBox)) : SubstanceComboBoxUI.this.uneditableArrowIcon.getIconWidth();
            if (SubstanceComboBoxUI.this.arrowButton != null) {
                if (!SubstanceComboBoxUI.this.comboBox.isEditable()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(0, 0, 0, 0);
                } else if (cb.getComponentOrientation().isLeftToRight()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(width - buttonWidth - insets.right, 0, buttonWidth + insets.right, height);
                } else {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(0, 0, buttonWidth + insets.left, height);
                }
            }
            if (SubstanceComboBoxUI.this.editor != null) {
                Rectangle r = SubstanceComboBoxUI.this.rectangleForCurrentValue();
                SubstanceComboBoxUI.this.editor.setBounds(r);
            }
        }
    }
}

