/*
 * Decompiled with CFR 0.152.
 */
package ru.akman.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class BaseToolMojo
extends AbstractMojo {
    private static final String JDK = "jdk";
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final int OLD_MAJOR = 1;
    private static final int NEW_MAJOR = 9;
    private static final int NEW_RECENT = 14;
    private static final int ANDROID_MAJOR = 0;
    private static final int ANDROID_MINOR = 9;
    private static final String JAVA_HOME_BIN = "bin";
    private static final String PATH = "PATH";
    private static final String PATHEXT = "PATHEXT";
    private static final String VERSION_PATTERN = "^(\\d+)(\\.(\\d+))?.*";
    private static final String VERSION_OPTION = "--version";
    private File baseDir;
    private File buildDir;
    private File outputDir;
    private Properties properties;
    private Charset sourceEncoding = Charset.defaultCharset();
    private FileSetManager fileSetManager;
    private List<Toolchain> toolchains;
    private Toolchain toolchain;
    private File toolHomeDirectory;
    private File toolExecutable;
    private String toolVersion;
    private JavaVersion toolJavaVersion;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;

    private Path getExecutableFromToolHome(String toolName, File toolHomeDir, String toolBinDirName) {
        Path executablePath;
        block4: {
            Path path = executablePath = toolHomeDir == null ? null : this.resolveToolPath(toolName, toolHomeDir.toPath(), toolBinDirName);
            if (executablePath != null) {
                try {
                    executablePath = executablePath.toRealPath(new LinkOption[0]);
                    this.toolHomeDirectory = toolHomeDir;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)MessageFormat.format("Executable (toolhome) for [{0}]: {1}", toolName, executablePath));
                        this.getLog().debug((CharSequence)MessageFormat.format("Home directory (toolhome) for [{0}]: {1}", toolName, this.toolHomeDirectory));
                    }
                }
                catch (IOException ex) {
                    if (!this.getLog().isWarnEnabled()) break block4;
                    this.getLog().warn((CharSequence)MessageFormat.format("Unable to resolve executable (toolhome) for [{0}]: {1}", toolName, executablePath), (Throwable)ex);
                }
            }
        }
        return executablePath;
    }

    private Path getExecutableFromToolchain(String toolName) {
        Path executablePath;
        block4: {
            String tcJavaHome = this.toolchain == null ? null : ((DefaultJavaToolChain)DefaultJavaToolChain.class.cast(this.toolchain)).getJavaHome();
            String tcToolExecutable = this.toolchain == null ? null : this.toolchain.findTool(toolName);
            executablePath = null;
            if (!StringUtils.isBlank(tcJavaHome) && !StringUtils.isBlank(tcToolExecutable)) {
                try {
                    executablePath = Paths.get(tcToolExecutable, new String[0]).toRealPath(new LinkOption[0]);
                    this.toolHomeDirectory = new File(tcJavaHome);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)MessageFormat.format("Executable (toolchain) for [{0}]: {1}", toolName, executablePath));
                        this.getLog().debug((CharSequence)MessageFormat.format("Home directory (toolchain) for [{0}]: {1}", toolName, this.toolHomeDirectory));
                    }
                }
                catch (IOException ex) {
                    if (!this.getLog().isWarnEnabled()) break block4;
                    this.getLog().warn((CharSequence)MessageFormat.format("Unable to resolve executable (toolchain) for [{0}]: {1}", toolName, executablePath), (Throwable)ex);
                }
            }
        }
        return executablePath;
    }

    private Path getExecutableFromJavaHome(String toolName) {
        Path executablePath;
        block4: {
            File javaHomeDir = this.getJavaHome();
            Path path = executablePath = javaHomeDir == null ? null : this.resolveToolPath(toolName, javaHomeDir.toPath(), JAVA_HOME_BIN);
            if (executablePath != null) {
                try {
                    executablePath = executablePath.toRealPath(new LinkOption[0]);
                    this.toolHomeDirectory = javaHomeDir;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)MessageFormat.format("Executable (javahome) for [{0}]: {1}", toolName, executablePath));
                        this.getLog().debug((CharSequence)MessageFormat.format("Home directory (javahome) for [{0}]: {1}", toolName, this.toolHomeDirectory));
                    }
                }
                catch (IOException ex) {
                    if (!this.getLog().isWarnEnabled()) break block4;
                    this.getLog().warn((CharSequence)MessageFormat.format("Unable to resolve executable (javahome) for [{0}]: {1}", toolName, executablePath), (Throwable)ex);
                }
            }
        }
        return executablePath;
    }

    private Path getExecutableFromSystemPath(String toolName) {
        Path executablePath;
        block5: {
            Path path;
            List<Path> systemPath = this.getSystemPath();
            executablePath = null;
            Iterator<Path> iterator2 = systemPath.iterator();
            while (iterator2.hasNext() && (executablePath = this.resolveToolPath(toolName, path = iterator2.next(), null)) == null) {
            }
            if (executablePath != null) {
                try {
                    Path toolHomePath = executablePath.getParent();
                    this.toolHomeDirectory = toolHomePath == null ? null : toolHomePath.toRealPath(new LinkOption[0]).toFile();
                    executablePath = executablePath.toRealPath(new LinkOption[0]);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)MessageFormat.format("Executable (systempath) for [{0}]: {1}", toolName, executablePath));
                        this.getLog().debug((CharSequence)MessageFormat.format("Home directory (systempath) for [{0}]: {1}", toolName, this.toolHomeDirectory));
                    }
                }
                catch (IOException ex) {
                    if (!this.getLog().isWarnEnabled()) break block5;
                    this.getLog().warn((CharSequence)MessageFormat.format("Unable to resolve executable (systempath) for [{0}]: {1}", toolName, executablePath), (Throwable)ex);
                }
            }
        }
        return executablePath;
    }

    private Path getToolExecutablePath(String toolName, File toolHomeDir, String toolBinDirName) {
        Path executablePath = this.getExecutableFromToolHome(toolName, toolHomeDir, toolBinDirName);
        if (executablePath != null) {
            return executablePath;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)MessageFormat.format("Executable (toolhome) for [{0}] not found", toolName));
        }
        if ((executablePath = this.getExecutableFromToolchain(toolName)) != null) {
            return executablePath;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)MessageFormat.format("Executable (toolchain) for [{0}] not found", toolName));
        }
        if ((executablePath = this.getExecutableFromJavaHome(toolName)) != null) {
            return executablePath;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)MessageFormat.format("Executable (javahome) for [{0}] not found", toolName));
        }
        if ((executablePath = this.getExecutableFromSystemPath(toolName)) != null) {
            return executablePath;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)MessageFormat.format("Executable (systempath) for [{0}] not found", toolName));
        }
        return executablePath;
    }

    private Path resolveToolPath(String toolName, Path toolHomeDir, String toolBinDirName) {
        if (toolHomeDir == null || StringUtils.isBlank(toolName)) {
            return null;
        }
        Path toolBinDir = toolHomeDir;
        if (!StringUtils.isBlank(toolBinDirName)) {
            toolBinDir = toolHomeDir.resolve(toolBinDirName);
        }
        if (!Files.exists(toolBinDir, new LinkOption[0]) || !Files.isDirectory(toolBinDir, new LinkOption[0])) {
            return null;
        }
        return this.findToolExecutable(toolName, List.of(toolBinDir));
    }

    private Path findToolExecutable(String toolName, List<Path> paths) {
        Path executablePath = null;
        Path toolFile = null;
        List<String> exts = this.getPathExt();
        block0: for (Path path : paths) {
            if (SystemUtils.IS_OS_WINDOWS) {
                for (String ext : exts) {
                    toolFile = path.resolve(toolName.concat(ext));
                    if (!Files.isExecutable(toolFile) || Files.isDirectory(toolFile, new LinkOption[0])) continue;
                    executablePath = toolFile;
                    continue block0;
                }
                continue;
            }
            toolFile = path.resolve(toolName);
            if (!Files.isExecutable(toolFile) || Files.isDirectory(toolFile, new LinkOption[0])) continue;
            executablePath = toolFile;
            break;
        }
        return executablePath;
    }

    private File getJavaHome() {
        String javaHome = StringUtils.stripToEmpty(System.getenv(JAVA_HOME));
        return StringUtils.isBlank(javaHome) ? null : new File(javaHome);
    }

    private List<Path> getSystemPath() {
        String systemPath = StringUtils.stripToEmpty(System.getenv(PATH));
        if (StringUtils.isBlank(systemPath)) {
            return new ArrayList<Path>();
        }
        return Stream.of(systemPath.split(File.pathSeparator)).filter(s2 -> !StringUtils.isBlank(s2)).map(s2 -> Paths.get(StringUtils.stripToEmpty(s2), new String[0])).collect(Collectors.toList());
    }

    private List<String> getPathExt() {
        String systemPathExt;
        if (SystemUtils.IS_OS_WINDOWS && !StringUtils.isBlank(systemPathExt = StringUtils.stripToEmpty(System.getenv(PATHEXT)))) {
            return Stream.of(systemPathExt.split(File.pathSeparator)).filter(s2 -> !StringUtils.isBlank(s2)).map(s2 -> StringUtils.stripToEmpty(s2)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private String obtainToolVersion(Path executablePath) throws CommandLineException {
        Commandline cmdLine = new Commandline();
        cmdLine.setExecutable(executablePath.toString());
        cmdLine.createArg().setValue(VERSION_OPTION);
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        return this.execCmdLine(cmdLine, out, err) == 0 ? StringUtils.stripToEmpty(out.getOutput()) : null;
    }

    private JavaVersion getCorrespondingJavaVersion(String version) {
        Matcher versionMatcher;
        JavaVersion resolvedVersion = null;
        if (version != null && (versionMatcher = Pattern.compile(VERSION_PATTERN).matcher(version)).matches()) {
            int minorVersion;
            String majorVersionPart = versionMatcher.group(1);
            int majorVersion = Integer.parseInt(majorVersionPart);
            String minorVersionPart = versionMatcher.group(3);
            int n = minorVersion = StringUtils.isBlank(minorVersionPart) ? 0 : Integer.parseInt(minorVersionPart);
            if (majorVersion >= 9) {
                resolvedVersion = majorVersion >= 14 ? JavaVersion.JAVA_RECENT : JavaVersion.valueOf("JAVA_" + majorVersion);
            } else if (majorVersion == 1 && minorVersion > 0 && minorVersion <= 9 || majorVersion == 0 && minorVersion == 9) {
                resolvedVersion = JavaVersion.valueOf("JAVA_" + majorVersion + "_" + minorVersion);
            }
        }
        return resolvedVersion;
    }

    private Toolchain getDefaultJavaToolchain() {
        Toolchain ctxToolchain = this.getToolchainManager().getToolchainFromBuildContext(JDK, this.getSession());
        return ctxToolchain == null || !(ctxToolchain instanceof DefaultJavaToolChain) ? null : ctxToolchain;
    }

    private void logCommandLineExecution(Commandline cmdLine, int exitCode, String stdout, String stderr) {
        if (exitCode == 0) {
            if (this.getLog().isDebugEnabled()) {
                if (!StringUtils.isBlank(stdout)) {
                    this.getLog().debug((CharSequence)(System.lineSeparator() + stdout));
                }
                if (!StringUtils.isBlank(stderr)) {
                    this.getLog().debug((CharSequence)(System.lineSeparator() + stderr));
                }
            }
        } else if (this.getLog().isErrorEnabled()) {
            this.getLog().error((CharSequence)(System.lineSeparator() + "Exit code: " + exitCode));
            if (!StringUtils.isBlank(stdout)) {
                this.getLog().error((CharSequence)(System.lineSeparator() + stdout));
            }
            if (!StringUtils.isBlank(stderr)) {
                this.getLog().error((CharSequence)(System.lineSeparator() + stderr));
            }
            this.getLog().error((CharSequence)(System.lineSeparator() + "Command line was: " + CommandLineUtils.toString(cmdLine.getCommandline())));
        }
    }

    protected File getBaseDir() {
        return this.baseDir;
    }

    protected File getBuildDir() {
        return this.buildDir;
    }

    protected File getOutputDir() {
        return this.outputDir;
    }

    protected Properties getProperties() {
        return this.properties;
    }

    protected Charset getCharset() {
        return this.sourceEncoding;
    }

    protected FileSetManager getFileSetManager() {
        return this.fileSetManager;
    }

    protected List<Toolchain> getToolchains() {
        return this.toolchains;
    }

    protected Toolchain getToolchain() {
        return this.toolchain;
    }

    protected File getToolHomeDirectory() {
        return this.toolHomeDirectory;
    }

    protected File getToolExecutable() {
        return this.toolExecutable;
    }

    protected String getToolVersion() {
        return this.toolVersion;
    }

    protected JavaVersion getToolJavaVersion() {
        return this.toolJavaVersion;
    }

    protected ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    protected BuildPluginManager getPluginManager() {
        return this.pluginManager;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected MavenSession getSession() {
        return this.session;
    }

    protected int execCmdLine(Commandline cmdLine) throws CommandLineException {
        return this.execCmdLine(cmdLine, null, null);
    }

    protected int execCmdLine(Commandline cmdLine, CommandLineUtils.StringStreamConsumer out, CommandLineUtils.StringStreamConsumer err) throws CommandLineException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)CommandLineUtils.toString(cmdLine.getCommandline()));
        }
        CommandLineUtils.StringStreamConsumer stdout = out == null ? new CommandLineUtils.StringStreamConsumer() : out;
        CommandLineUtils.StringStreamConsumer stderr = err == null ? new CommandLineUtils.StringStreamConsumer() : err;
        int exitCode = CommandLineUtils.executeCommandLine(cmdLine, stdout, err);
        this.logCommandLineExecution(cmdLine, exitCode, stdout.getOutput(), stderr.getOutput());
        return exitCode;
    }

    protected void init(String toolName, File toolHomeDir, String toolBinDirName) throws MojoExecutionException {
        Path executablePath;
        block28: {
            if (this.getProject() == null) {
                throw new MojoExecutionException("Error: The predefined variable ${project} is not defined");
            }
            if (this.getSession() == null) {
                throw new MojoExecutionException("Error: The predefined variable ${session} is not defined");
            }
            this.baseDir = this.getProject().getBasedir();
            if (this.baseDir == null) {
                throw new MojoExecutionException("Error: The predefined variable ${project.basedir} is not defined");
            }
            this.buildDir = new File(this.getProject().getBuild().getDirectory());
            if (this.buildDir == null) {
                throw new MojoExecutionException("Error: The predefined variable ${project.build.directory} is not defined");
            }
            this.outputDir = new File(this.getProject().getBuild().getOutputDirectory());
            if (this.outputDir == null) {
                throw new MojoExecutionException("Error: The predefined variable ${project.build.outputDirectory} is not defined");
            }
            this.properties = this.getProject().getProperties();
            if (this.properties == null) {
                throw new MojoExecutionException("Error: Unable to read project properties");
            }
            this.fileSetManager = new FileSetManager();
            if (this.fileSetManager == null) {
                throw new MojoExecutionException("Error: Unable to create file set manager");
            }
            String encoding = this.properties.getProperty("project.build.sourceEncoding");
            try {
                this.sourceEncoding = Charset.forName(encoding);
            }
            catch (IllegalArgumentException ex) {
                if (!this.getLog().isWarnEnabled()) break block28;
                this.getLog().warn((CharSequence)"Unable to read ${project.build.sourceEncoding}");
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)MessageFormat.format("Using source encoding: [{0}] to write files", this.sourceEncoding));
        }
        this.toolchains = this.getToolchainManager().getToolchains(this.getSession(), JDK, null);
        if (this.toolchains == null) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"No toolchains found");
            }
        } else {
            this.toolchains.forEach(tc -> {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Found toolchain: " + tc));
                }
            });
        }
        this.toolchain = this.getDefaultJavaToolchain();
        if (this.toolchain == null) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Toolchain not specified");
            }
        } else if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Using toolchain: " + this.toolchain));
        }
        if ((executablePath = this.getToolExecutablePath(toolName, toolHomeDir, toolBinDirName)) == null) {
            throw new MojoExecutionException(MessageFormat.format("Error: Executable for [{0}] not found", toolName));
        }
        this.toolExecutable = executablePath.toFile();
        try {
            this.toolVersion = this.obtainToolVersion(executablePath);
        }
        catch (CommandLineException ex) {
            throw new MojoExecutionException(MessageFormat.format("Error: Unable to obtain version of [{0}]", toolName), (Exception)ex);
        }
        if (this.toolVersion == null) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)MessageFormat.format("Unable to resolve version of [{0}]", toolName));
            }
        } else if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)MessageFormat.format("Version of [{0}]: {1}", toolName, this.toolVersion));
        }
        this.toolJavaVersion = this.getCorrespondingJavaVersion(this.toolVersion);
        if (this.toolJavaVersion == null) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)MessageFormat.format("Unable to resolve corresponding java version of [{0}]", toolName));
            }
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)MessageFormat.format("Version (corresponding java version) of [{0}]: {1}", new Object[]{toolName, this.toolJavaVersion}));
        }
    }
}

